# Help Desk & Ticket Support System

A comprehensive ticket support system built with Laravel, PHP, HTML, CSS, and JavaScript.

## Features

### Customer/Client Features
- User registration and authentication
- Create tickets with text description and file attachments
- View ticket status and replies
- Search knowledge base articles
- Browse knowledge base documentation

### Admin Features
- Admin dashboard with statistics
- Manage all tickets
- Reply to tickets with attachments
- Email notifications for ticket replies
- Manage knowledge base articles
- System settings (Logo, SEO, Timezone)

## Installation

1. Clone the repository
2. Install dependencies:
   ```bash
   composer install
   npm install
   ```

3. Copy `.env.example` to `.env`:
   ```bash
   cp .env.example .env
   ```

4. Generate application key:
   ```bash
   php artisan key:generate
   ```

5. Configure your database in `.env` file

6. Run migrations:
   ```bash
   php artisan migrate
   ```

7. Create storage link:
   ```bash
   php artisan storage:link
   ```

8. (Optional) Run seeder to create default admin and test user:
   ```bash
   php artisan db:seed
   ```
   Default credentials:
   - Admin: admin@example.com / password
   - User: user@example.com / password
   
   Or create an admin user manually using Laravel Tinker (see below)

9. Start the development server:
   ```bash
   php artisan serve
   ```

10. In another terminal, start Vite:
    ```bash
    npm run dev
    ```

## Database Structure

- **users**: User accounts (clients and admins)
- **tickets**: Support tickets
- **ticket_replies**: Replies to tickets
- **ticket_attachments**: File attachments for tickets and replies
- **knowledge_base**: Knowledge base articles
- **settings**: System settings

## Default Admin

To create an admin user, you can use Laravel Tinker:

```bash
php artisan tinker
```

Then run:
```php
$user = new App\Models\User();
$user->name = 'Admin';
$user->email = 'admin@example.com';
$user->password = Hash::make('password');
$user->role = 'admin';
$user->save();
```

## Email Configuration

Configure your email settings in `.env` file for ticket reply notifications:

```
MAIL_MAILER=smtp
MAIL_HOST=your-smtp-host
MAIL_PORT=587
MAIL_USERNAME=your-email
MAIL_PASSWORD=your-password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=noreply@example.com
MAIL_FROM_NAME="Ticket System"
```

## File Storage

Uploaded files are stored in `storage/app/public/ticket-attachments` and `storage/app/public/logos`. Make sure to run `php artisan storage:link` to create the symbolic link.

## License

MIT

